/************************************************************************
 * NAME:	dmk.h
 *
 * DESCR:	Information, structures, and defines for the DMK format.
 *
 ************************************************************************/

#define DMK_SIDE(opts)		(opts&0x10)	/* side bit - set = single side	*/
#define   DMK_SIDE_SET(sides)	((sides==1)?0x10:0x00)

/* note that DMK doesn't really know how to handle encodings that are
   not WD_[M]FM.  It will simply default to double density.		*/

#define DMK_DENSITY(opts)	(opts&0x40)	/* density - set = single dens	*/
#define   DMK_DENSITY_SET(enc)	((enc==WD_FM)?0x40:(enc==RX02)?DMK_RX02_SET():0x00)

#define DMK_IGNORE(opts)	(opts&0x80)
#define DMK_RX02(opts)		(opts&0x20)
#define   DMK_RX02_SET()	(0x20)

#define DMK_DDEN(flags)		(flags&0x8000)
#define   DMK_DDEN_SET(flags)	(flags|0x8000)
#define DMK_XTRA(flags)		(flags&0x4000)
#define DMK_FLAGMASK(flags)	(flags&0x3fff)

#define E_DMK_FORMAT_TXT	"DMK Format Error: "

#define E_DMK_WP		0x01
#define E_DMK_ZEROS		0x02
#define E_DMK_DAM		0x03
#define E_DMK_EOF		0x04

#define E_DMK_STRING(v)		(v == E_DMK_WP)? E_DMK_FORMAT_TXT "write protect flag" :	\
                                (v == E_DMK_ZEROS)? E_DMK_FORMAT_TXT "zero padding" :		\
                                (v == E_DMK_DAM)? E_DMK_FORMAT_TXT "missing DAM" :		\
                                (v == E_DMK_EOF)? E_DMK_FORMAT_TXT "end of file" :		\
                                E_DMK_FORMAT_TXT "unknown"
